<?php

#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 20.01.2025

require_once 'function.inc.php';
initializeDatabaseConnection();

// Alarm
if ($_GET['api'] == 'alarm') {

    $alarmData = [
        "status" => getDBEntry('SystemOptions', 'Option', 'AlarmStatus', 'Value'),
        "type" => getDBEntry('SystemOptions', 'Option', 'AlarmType', 'Value'),
        "message" => getDBEntry('SystemOptions', 'Option', 'AlarmMessage', 'Value')
    ];

    header('Content-Type: application/json');
    echo json_encode($alarmData);

}

// Validiere das Passwort des Benutzers in der Datenbank
if ($_GET['api'] == 'validatePassword') {

    $username = $_SESSION['Username'];
    $inputPassword = $_POST['current_password'];

    $sql = "SELECT Password FROM Accounts WHERE Username = :username";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':username', $username);
    $stmt->execute();

    $userPassword = $stmt->fetchColumn();

    if ($userPassword) {
        if (password_verify($inputPassword, $userPassword)) {
            echo 'true';
        } else {
            echo 'false';
        }
    } else {
        echo 'false';
    }
}

// Prüfen ob der Benutzername noch frei ist
if ($_GET['api'] == 'isUsernameAvailable') {

    $username = $_POST['accountUsername'];

    $sql = "SELECT COUNT(*) FROM Accounts WHERE Username = :username";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':username', $username);
    $stmt->execute();

    $isUsernameAvailable = $stmt->fetchColumn();

    if ($isUsernameAvailable) {
        echo 'false';
    } else {
        echo 'true';
    }
}

// Prüfen ob die Zutrittskarte noch frei ist
if ($_GET['api'] == 'isAccessCardAvailable') {

    $accessCard = $_POST['positionAccessCard'];

    $sql = "SELECT COUNT(*) FROM Positions WHERE OwnerAccessCard = :accessCard";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':accessCard', $accessCard);
    $stmt->execute();

    $isAccessCardAvailable = $stmt->fetchColumn();

    if ($isAccessCardAvailable) {
        echo 'false';
    } else {
        echo 'true';
    }
}

// Prüfen ob die Dienstposten-ID noch frei ist
if ($_GET['api'] == 'isPositionIDAvailable') {

    $ID = $_POST['positionID'];

    $sql = "SELECT COUNT(*) FROM Positions WHERE ID = :ID";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':ID', $ID);
    $stmt->execute();

    $isPositionIDAvailable = $stmt->fetchColumn();

    if ($isPositionIDAvailable) {
        echo 'false';
    } else {
        echo 'true';
    }
}

// Sperrliste : Prüfe ob Ausweis nicht in der Sperrliste existiert
if ($_GET['api'] == 'blacklistCheckIDCard') {

    $identityIDCard = $_POST['identityIDCard'];

    $sql = "SELECT COUNT(*) FROM BlacklistLocals WHERE IDCard = :IDCard";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':IDCard', $identityIDCard);
    $stmt->execute();

    $checkBlacklist = $stmt->fetchColumn();

    if ($checkBlacklist) {
        echo 'false';
    } else {
        echo 'true';
    }
}

?>